package executorServices;

import chapter8.TakeABreak;

public class ExampleRunnableWithParameters implements Runnable {
    int[] numbers;//array to process
    int pos=0;//current position in the array
//    public int sum=0;//store the total of the array (as processed by the various tasks)
    
    
    public ExampleRunnableWithParameters(int... numbers){
        this.numbers=numbers;
    }
    
    @Override
    public void run() {
        while (pos<numbers.length){
            processData();
            TakeABreak.sleep();
        }
    }
    
    private synchronized void processData(){
        //check to make sure that we haven't reached the end.
        if (pos>=numbers.length) return;
        System.out.println("Number: "+numbers[pos] //Print out i
                                   +" Processed by: "
                                   +Thread.currentThread().getName());
//        sum+=numbers[pos];//calculate the total
        pos++;//Explicity increment i
    }
}
